// cforth.c Header file of the CForth C011(SO8) project ************************
//
// Author and (c)2025 Wolfgang Schemmert. The copyright claim is	restricted
// to this file and the	depending files	"main.c", "main.h", "cforth.c",
// and "globaldefines.h"
// Other depending material is published, copyrighted and licensed
// by STMicroelectronics and Segger GmbH
//
// Contact: <www.midi-and-more.de>
// A detailled hardware construction and operation manual
// is provided at this website
//
// ***************************************************************************
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
//	Licence: GPL-3
//
// ***************************************************************************

#include "globaldefines.h"

//from main.h
extern uint8_t *gUSART_RXHEAD, *gUSART_RXTAIL;
extern uint8_t gUSART_RXBUF[];
extern uint32_t gSYSCOUNT, gLEDCOUNT, gTIMEOUT;
extern uint32_t gBaud, gBaudSet, gProject, gTxOff;
extern const uint8_t gTypeStr[];

extern void SetSysClock(void);
extern void popFlashProject(uint32_t);
extern uint32_t pushFlashProject(void);
extern void msDelay(uint32_t);
extern void wait5us(void);
extern void servSystem(void);
extern void initUsart1(void);
extern void subInitUsart1(void);
extern void sendTB(uint8_t);
extern void sendString(const uint8_t *);
extern void sendNibble(uint8_t);
extern void sendX8(uint32_t);
extern void sendX32(uint32_t);
extern void sendNX32(uint32_t);
extern void send0X32(uint32_t);
extern void sendLS32(uint32_t);
extern void sendS32(uint32_t);
extern void sendNS32(uint32_t);
extern uint32_t pullTermRxBuf(void);

// #########################################################

#define	IDX_CONTI		0x61
#define	IDX_BREAK		0x63
#define	IDX_ZBREAK		0x64
#define	IDX_SEMIS		0x67
#define	IDX_DOSTR		0x68
#define	IDX_DOLIT8B		0x69
#define	IDX_DOLIT		0x6A
#define	IDX_DOWVA		0x6B
#define	IDX_DOIF		0x6C
#define	IDX_DOCASE		0x6D
#define	IDX_DOLTCAS		0x6E
#define	IDX_DOGTCAS		0x6F
#define	IDX_DOELSE		0x70
#define	IDX_DODO		0x71
#define	IDX_DOUNTIL		0x72
#define	IDX_DOWHILE		0x73
#define	IDX_DOAGAIN		0x74
#define	IDX_DOFOR		0x75
#define	IDX_DOLOOP		0x76
#define	IDX_RPDEC		0x77
#define	IDX_RP4DEC		0x78


//arithmetic ops 
void op_ERR(void);
void op_DROP(void);
void op_DUP(void);
void op_SWAP(void);
void op_OVER(void);
void op_ROT(void);
void op_PICK(void);
void op_ROLL(void);
void op_INJECT(void);
void op_PLUS(void);
void op_INCT(void);
void op_MINUS(void);
void op_DECT(void);
void op_ABS(void);
void op_SHIFT(void);
void op_AND(void);
void op_OR(void);
void op_XOR(void);
void op_NOT(void);
void op_NEG(void);
void op_MULT(void);
void op_DIV(void);
void op_MULTDIV(void);
void op_MOD(void);
void op_DIVMOD(void);
void op_BSET(void);
void op_BCLR(void);
void op_BTST(void);
void op_RANDOM(void);
//comparison ops
void op_EQUAL(void);
void op_UNEQU(void);
void op_ZEQ(void);
void op_GRTR(void);
void op_GRTREQ(void);
void op_LESS(void);
void op_ULESS(void);
void op_LESSEQ(void);

//memory ops
void op_VARCON(void);
void op_WVA(void);
void op_REPLACE(void);
void op_RESTORE(void);

//terminal ops
void op_KEYQ(void);
void op_KEY(void);
void op_EMIT(void);
void op_PRINT(void);
void op_PRINTHEX(void);
void op_PRINTDEC(void);
void op_PRINTSTR(void);
void op_DECIM(void);
void op_HEX(void);
void op_TXON(void);

//timed ops
void op_XNOP(void);
void op_MS(void);
void op_DECIS(void);
void op_TIX(void);
void op_TIME(void);
void op_FREQ();
void op_PWM1();
void op_MOT();
void op_PWM2();

//peripheral ops
void op_PINOH(void);
void op_PINOL(void);
void op_PINIPU(void);
void op_PINIPD(void);
void op_PINIZ(void);
void op_READDIG(void);
void op_READADC(void);
void op_INITSPI(void);
void op_SPI(void);

void op_REGWRITE(void);
void op_REGREAD(void);

//structuring ops
void op_IF(void);
void op_ELSE(void);
void op_THEN(void);
void op_DO(void);
void op_CASE(void);
void op_LTCASE(void);
void op_GTCASE(void);
void op_UNTIL(void);
void op_WHILE(void);
void op_AGAIN(void);
void op_FOR(void);
void op_IDX(void);
void op_LOOP(void);
void op_BREAK(void);
void op_ZBREAK(void);
void op_CONTI(void);
void op_RETURN(void);

//compiler ops
void op_PRINTSTACK(void);
void op_OPS(void);
void op_USER(void);
void op_SEE(void);
void op_STEP(void);
void op_RUN(void);
void op_NOBAK(void);
void op_BAKOP(void);
void op_MEM(void);
void op_FORGET(void);
void op_FLUSH(void);
void op_ABORT(void);
void op_PA1SET(void);
void op_NRSET(void);
void op_REPLACE(void);
void op_RESTORE(void);
void op_COLON(void);
void op_SEMIS(void);

//runtime ops
void op_DOSTRING(void);
void op_DOIOSTR(void);
void op_DOLIT(void);
void op_DOLIT8B(void);
void op_DOWVA(void);
void op_DOIF(void);
void op_DOCASE(void);
void op_DOLTCAS(void);
void op_DOGTCAS(void);
void op_DOELSE(void);
void op_DODO(void);
void op_DOUNTIL(void);
void op_DOWHILE(void);
void op_DOAGAIN(void);
void op_DOFOR(void);
void op_DOLOOP(void);
void op_RPDEC(void);
void op_RP4DEC(void);
//system ops
void op_AUTO(void);
void op_BAUD(void);
void op_QUEST(void);
void op_SAVEFLASH(void);
void op_LOADFLASH(void);

void op_RDOPT(void);
void op_CHGOPT(void);

//all globals declared here start with leading "gf" to differ from "main.h"
uint32_t gfMSCOUNT, gfTIXCOUNT; //1ms countdown in "SysTick_Handler()"
uint8_t gfTib[100], gfTokenstr[80];
uint32_t gfTibMax; 
uint32_t gfTokenStart, gfTibPos;
int32_t gfTokenNum;		//simplifies parameter passing in "interpretNumber()"
uint32_t gfErrors=0;
uint32_t gfNumBase, gfTempNumBase, gfAuto;
uint32_t gfCompiState=0;	//0=interpreting, 1=compiling
uint32_t gfExecUser=0;		//for query(): 1=User token is executing, 0=else
uint32_t gfBackProcData, gfBackNumValid;	//primitive1 level data stack
uint32_t gfTermCheck;	//message from checkTerminal() to KEY?
uint8_t gfTermChar;	//last terminal char while (gfBackProcess && gfExecUser)
uint32_t gfComment=0;		//(!=0):ignore following TIB input, 0:evaluate
							//is set to	0 by every CRR
uint32_t gfCodeIndex=0, gfCodeStartIndex=0;		// code	Startvalue
uint32_t gfNextNameCompi=0;	//gfUserHeader[] next entry index
uint32_t gfParsed;
uint32_t gfTrace, gfBackProcess=0;	
							//init here as precaution,emptyForth()->final init
uint32_t gfTermInput;		//message from terminal	iput to	DEBUG();
uint8_t *gfIPold;
uint32_t gfNestLevel, gfBackNestLevel;
uint32_t gfIpVal;
uint32_t gfRandom;
uint32_t gfSpiMode, gfSpiBits, gfSpiClock;
int32_t gfPWM1;
uint32_t gfFreq;
int32_t gfStepSpeed, gfStepPhase, gfSTEPCOUNT;
int32_t gfPWM2;

uint32_t gfDataStack[MAXDATASTACK];
uint32_t gfReturnStack[MAXRETSTACK];
uint8_t gfTCode[MAXCODE];
//1536bytes = 3/4 page of 208 bytes

uint32_t *gfSP;				//Datastack Pointer: rising	with new TOS
uint32_t *gfRP;				//Returnstack Pointer: rising with new function
uint8_t *gfIP;				//Instruction Pointer

const uint8_t gfKernelNames	[KERNELSIZE][8] = {
	{"ERROR"}, //index	0: dummy to	signal if operation in empty user code
	{"DROP"},{"DUP"},{"SWAP"},{"OVER"},			//index	1..4
	{"ROT"},{"PICK"},{"ROLL"},{"INJECT"},{"+"},		//5...9
	{"1+"},{"-"},{"1-"},{"ABS"},{"SHIFT"},			//10...14
	{"AND"},{"OR"},{"XOR"},{"NOT"},{"+/-"},			//15...19 =0x0F...0x13
	{"*"},{"/"},{"*/"},{"MOD"},{"/MOD"},			//20. .24 =0x14...0x18
	{"BSET"},{"BCLR"},{"BTST"},{"RANDOM"},{"=="},	//25...29 =0x19...0x1D
	{"!="},{">"},{">="},{"<"},{"U<"},				//30...34 =0x1E...0x22
	{"<="},{"0="},{"VARCON"},{"W"},{"TXON"},		//35...39 =0x23...0x27
	{"KEY?"},{"KEY"},{"EMIT"},{"."},{".H"},			//40...45 =0x28...0x2C
	{".D"},{".\""},{"DZ"},{"HX"},{"XNOP"},			//45...49 =0x2D...0x31
	{"MS"},{"DS"},{"TIX"},{"TIME"},{"FREQ"},		//50...54 =0x32...0x36
	{"PWM1"},{"MOT"},{"PWM2"},{"OH"},{"OL"},		//55...59 =0x37...0x39
	{"IPU"},{"IPD"},{"IZ"},{"RDIN"},{"RADC"},		//60...64 =0x3C...0x40
	{"INI-SPI"},{"SPI"},{"REGW"},{"REGR"},{".S"},	//65...69 =0x41...0x45
	{"FS"},{"OPS"},{"USER"},{"SEE"},{"MEM"},		//70...74 =0x46...0x4A
	{"ST"},{"RUN"},{"NOBACK"},{"BACKOP"},{"FORGET"},//75...79 =0x4B...0x4F
	{"ABORT"},{"NRSET"},{"PA1SET"},{"REPLACE"},{"RESTORE"},//80-84 =0x50-0x54
	{"IF"},{"CASE"},{"<CASE"},{">CASE"},{"ELSE"},	//85...89.=0x55...0x59
	{"THEN"},{"DO"},{"UNTIL"},{"WHILE"},{"AGAIN"},	//90. .94 =0x5A...0x5E
	{"FOR"},{"LOOP"},{"I"},{"CONTI"},{"BREAK"},		//95...99 =0x5F...0x63
	{"ZBREAK"},{"RETURN"},{":"},{";"},{"doSTR"},	//100...104=0x64..0x68
	{"doLIT8"},{"doLIT"},{"doWVA"},{"doIF"},{"doCASE"},//105..109=0x69..0x6D
	{"do<CASE"},{"do>CASE"},{"doELSE"},{"doDO"},{"doUNTIL"},//110-114=0x6E-0x72
	{"doWHILE"}, {"doAGAIN"},{"doFOR"},{"doLOOP"},{"RP-1"},//115-119=0x73-0x77
	{"RP-4"},{"AUTOEXE"},{"BAUD"},{"?"},{"SAVE"},	//120...124=0x78...0x7C
	{"LOAD"}										//125=0x7D
};

void (*	gfKernelOps	[KERNELSIZE]) () = {
op_ERR,												//index	0
op_DROP, op_DUP, op_SWAP, op_OVER,					//index	1..4
op_ROT,	op_PICK, op_ROLL, op_INJECT, op_PLUS,		//5...9
op_INCT, op_MINUS, op_DECT,	op_ABS,	op_SHIFT,		//10...14
op_AND,	op_OR, op_XOR, op_NOT, op_NEG,				//15...19 =0x0F...0x13
op_MULT, op_DIV, op_MULTDIV, op_MOD, op_DIVMOD,		//20...24 =0x14...0x18
op_BSET, op_BCLR,op_BTST,op_RANDOM,	op_EQUAL,		//25...29 =0x19...0x1D
op_UNEQU, op_GRTR, op_GRTREQ, op_LESS, op_ULESS,	//30...34 =0x1E...0x22
op_LESSEQ, op_ZEQ, op_VARCON, op_WVA, op_TXON,		//35...39 =0x23...0x27
op_KEYQ, op_KEY, op_EMIT, op_PRINT,op_PRINTHEX,		//40...44 =0x28...0x2C
op_PRINTDEC, op_PRINTSTR, op_DECIM,	op_HEX,op_XNOP,	//45...49.=0x2D...0x31
op_MS, op_DECIS, op_TIX, op_TIME,op_FREQ,			//50...54 =0x32...0x36
op_PWM1,op_MOT,op_PWM2,op_PINOH,op_PINOL,			//55...59 =0x37...0x39
op_PINIPU, op_PINIPD, op_PINIZ,	op_READDIG,op_READADC,	//60...64 =0x3C...0x40
op_INITSPI,	op_SPI,	op_REGWRITE, op_REGREAD, op_PRINTSTACK,//65..69=0x41..0x45
op_FLUSH, op_OPS, op_USER, op_SEE, op_MEM,			//70...74 =0x46...0x4A
op_STEP, op_RUN, op_NOBAK, op_BAKOP, op_FORGET,		//75...79 =0x4B...0x4F
op_ABORT, op_NRSET,	op_PA1SET, op_REPLACE, op_RESTORE,//80...84 =0x50...0x54
op_IF,op_CASE, op_LTCASE, op_GTCASE, op_ELSE,		//85...89 =0x55...0x59
op_THEN, op_DO,	op_UNTIL, op_WHILE,	op_AGAIN,		//90...94 =0x5A...0x5E
op_FOR,	op_LOOP, op_IDX, op_CONTI, op_BREAK,		//95...99 =0x5F...0x63
op_ZBREAK, op_RETURN, op_COLON,	op_SEMIS, op_DOSTRING,//100..104=0x64...0x68
op_DOLIT8B,	op_DOLIT,op_DOWVA, op_DOIF,	op_DOCASE,	//105...109=0x69..0x6D
op_DOLTCAS,	op_DOGTCAS,	op_DOELSE, op_DODO,	op_DOUNTIL,//110...114=0x6E..0x72
op_DOWHILE,	op_DOAGAIN,	op_DOFOR, op_DOLOOP, op_RPDEC,//115...119=0x73..0x77
op_RP4DEC,op_AUTO, op_BAUD,	op_QUEST,op_SAVEFLASH,	//120...124=0x78..0x7C
op_LOADFLASH										//125=0x7D


};

const uint32_t gfKernelAttributes [KERNELSIZE] = {
	0,										//index	0
	0,0,0,0,0,0,0,0,0,					//index	1...9
	0,0,0,0,0,0,0,0,0,0,				//10...19 =0x0A...0x13
	0,0,0,0,0,0,0,0,0,0,				//20...29 =0x14...0x1D
	0,0,0,0,0,							//30...34 =0x1E...0x22
	0,0,A_IME,A_IB,0,					//35...39 =0x23...0x27
	0,0,0,0,0,							//40...44 =0x28...0x2C
	0,A_IME,A_IB,A_IB,0,				//45...49 =0x2D...0x31
	0,0,0,0,A_BAK,						//50...54 =0x2D...0x31
	A_BAK,A_BAK,A_BAK,0, 0,				//55...59 =0x37...0x39
	0,0,0,0,0,							//59...64 =0x3B...0x40
	0,0,0,0, A_BAK,						//65...69 =0x41...0x45
	0,A_IB,A_IB,A_IB,A_BAK,				//70...74 =0x46...0x4A
	A_BAK,A_BAK,A_BAK,0,A_IME,			//75...79 =0x4B...0x4F
	A_IME,0,0,A_IME,A_IME,				//80...84 =0x50...0x54
	A_CI,A_CI,A_CI,A_CI,A_CI,			//85...89 =0x55...0x59
	A_CI,A_CI,A_CI,A_CI,A_CI,			//90...94 =0x5A...0x5E
	A_CI,A_CI,A_CPO,A_CPO,A_CPO,		//95...99 =0x5F...0x63
	A_CPO,A_CPO,A_IME,A_IME,A_RUN,		//100...104=0x64..0x68
	A_RUN,A_RUN,A_RUN,A_RUN,A_RUN,		//105...109=0x69..0x6D
	A_RUN,A_RUN,A_RUN,A_RUN,A_RUN,		//110...114=0x6E..0x72
	A_RUN,A_RUN,A_RUN,A_RUN,A_CPO,		//115...119=0x73..0x77
	A_CPO,A_IME,A_IME,A_IB,	A_IME,		//120...124=0x78..0x7C
	A_IME								//125=0x7D
};

struct USERHEADER
{
uint8_t name[8];
uint32_t toCompile;
uint32_t attributes;  //options see "globaldefines.h"
} gfUserHeader[MAXUSER];
//4 words = 16 bytes/struct *96 elements=384 words=1536 bytes = 3/4 page

const uint8_t gfCancelStr [] = " cancelled ";
const uint8_t gfProjectStr [] = "Project no.";
const uint8_t gfEmptyStr [] = "Empty_Project";
const uint8_t gfLoadStr	[] = "Load ";
const uint8_t gfSaveStr	[] = "Save ";

void quit(void);
uint32_t query(void);
uint32_t subQuery(void);
void eval(void);
void backProcEval(void);
void scanNext(void);
uint32_t interpretNumber(void);		//if success, result comes in "gfTokenNum"
uint32_t string2Int(uint8_t*, uint32_t);
uint32_t checkDigit(uint8_t, uint32_t);
uint32_t findKernelToken(void);
uint32_t findUserToken(void);
void interpretKernelToken(void);
uint32_t interpretUserToken(void);
uint32_t compileUserSymbol(uint32_t);
void compileTCode(uint32_t);
void executeTCode(void);
void intoUserCode(void);
uint32_t checkVarcon(uint32_t);
void execNext(void);
void showPreStep(uint32_t);
void showPostStep(void);
void emptyForth(void);
uint32_t checkTerminal(void);
void scanString(void);
uint32_t packBackslash(uint32_t);
void subFREQ(void);
void subPWM1(void);
void subMOT(void);
void subPWM2(void);
uint32_t checkValidIO(uint32_t);
void checkPWM(uint32_t);
void initADC(void);
void disableADC(void);
void subInitSpi(void);
void prepareElse(void);
void prepareBack(void);
void token2String(uint32_t);
void index2String(uint32_t);
uint32_t getToken(void);
void toElse(void);
void initTop(void);
void handleOptByte(uint32_t);
uint32_t checkProjectNum(uint32_t);
uint32_t conFirm(void);
void checkBackNum(void);

// ##################### end of	file #########################################