// main.h Header file of the CForth C011(SO8) project ************************
//
// Author and (c)2025 Wolfgang Schemmert. The copyright claim is	restricted
// to this file and the depending files "main.c", "cforth.c", "cforth.h"
// and "globaldefines.h"
// Other depending material is published, copyrighted and licensed
// by STMicroelectronics and Segger GmbH
//
// Contact: <www.midi-and-more.de>
// A detailled hardware construction and operation manual
// is provided at this website
//
// ***************************************************************************
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
//	Licence: GPL-3
//
// ***************************************************************************

#include "globaldefines.h"

// from	cforth.h
extern uint32_t gfMSCOUNT, gfTIXCOUNT;
extern uint32_t gfTibMax;
extern uint32_t gfTermInput;
extern uint32_t gfBackProcess, gfBackNumValid;
extern uint32_t gfNextNameCompi;
extern uint32_t gfNumBase, gfTempNumBase, gfAuto;
extern uint32_t gfSpiMode, gfSpiBits, gfSpiClock;
extern int32_t gfPWM1;
extern uint32_t gfFreq,	gfBaseFreq;
extern int32_t gfSTEPCOUNT;
extern int32_t gfPWM2;

extern uint32_t gfCompiState;		//0=interpreting, 1=compiling
extern uint32_t gfErrors, gfParsed;
extern uint32_t *gfSP;				//Datastack Pointer
extern uint32_t *gfRP;				//Returnstack Pointer
extern uint32_t *gfIP;				//Instruction Pointer
extern int32_t gfArray[];
extern uint8_t gfTCode[];			//1536bytes = 3/4 page

extern const uint8_t gfProjectStr [];

extern struct USERHEADER
{
uint8_t name[16];
uint32_t toCompile;
uint32_t attributes;
} gfUserHeader[MAXUSER];
//4	words = 6 bytes/struct*96 elements=384 words=156 bytes=ca.3/4page

extern void quit(void);
extern uint32_t query(void);
extern void eval(void);
extern uint32_t interpretUserToken(void);
extern uint32_t executeTCode(void);
extern void emptyForth(void);
extern void op_NOP(void);
extern void op_BAKOP(void);
extern void op_ABORT(void);
extern void op_VER(void);
extern void op_QUEST(void);
extern void subFREQ(void);
extern void subPWM1(void);
extern void subPWM2(void);
extern void op_SPEED(void);

// ****************************************


uint8_t gUSART_RXBUF[USART_RXBUFLEN+4];
uint8_t *gUSART_RXHEAD=0,*gUSART_RXTAIL=0,*gUSART_RXBUFTOP= &(gUSART_RXBUF[USART_RXBUFLEN]);
//system control
uint32_t gSYSCOUNT, gLEDCOUNT, gDELAYCOUNT, gTIMEOUT;
uint32_t  gBaud, gBaudSet, gProject, gTxOff;
uint32_t gTest1, gTest2;		//for debugging only
uint32_t gRandom;

#ifdef CLOCK_48M
const uint8_t gTypeStr [] = "CForth  STM32C011J6(SO8) -int.RC_Osc 48MHz- v.";
#else
const uint8_t gTypeStr [] = "CForth  STM32C011(SO8) -int.RC_Osc 3.0MHz- v.";
#endif
const uint8_t gCopyStr[] = " (c)2025 W.Schemmert";
const uint8_t gEmptyStr[] = " ordered, but is Empty !";

void SetSysClock(void);
void msDelay(uint32_t);
void wait5us(void);
void servSystem(void);

void popFlashProject(uint32_t);
uint32_t pushFlashProject(void);

//USART
void initUsart1(void);
void subInitUsart1(void);
void sendTB(uint8_t);
void sendString(const uint8_t *);
void sendNibble(uint8_t);
void sendX8(uint32_t);
void sendX32(uint32_t);
void sendNX32(uint32_t);
void send0X32(uint32_t);
void sendLS32(uint32_t);
void sendS32(uint32_t);
void sendNS32(uint32_t);
void sendE(float);
uint32_t pullTermRxBuf(void);
uint8_t parseHexNibble(uint8_t);
uint32_t parseHexNum(uint8_t);
uint8_t parseDeciDigit(void);

//Interrupt handlers
//void SysTick_Handler(void);
//void USART1_IRQHandler(void);
